\name{iplot}
\alias{iplot}
\title{Interaction Plot for Multiple MCMCpack Regression Models}
\description{Draws an interaction plot for an MCMCpack regression model.}
\usage{iplot(model, focal, fixed, at=NULL, probs=c(0.025, 0.975),
             ylim=NULL, xlim=NULL, rug=TRUE, pcol=NULL, xlab=NULL,
             ylab=NULL, pch=NULL, las=NULL, steps=10, ...)}
\arguments{ \item{model}{regression model created with MCMCpack}
            \item{focal}{focal variable}
            \item{fixed}{fixed variable}
            \item{at}{values at which the fixed variable should be shown, optional}
            \item{probs}{uncertainty intervals, optional}
            \item{ylim}{vector of minimum and maximum of the y-axis, optional}
            \item{xlim}{vector of minimum and maximum of the x-axis, optional}
            \item{rug}{include a rug plot on the x-axis, defaults to TRUE}
            \item{pcol}{colours of the lines and polygons, optional}
            \item{xlab}{label on the x-axis, optional}
            \item{ylab}{label on the y-axis, optional}
            \item{pch}{character to plot estimate for categorical variables}
            \item{las}{orientation of lables on y-axis for categorical variables}
            \item{steps}{number of steps for the predicted values}
            \item{...}{other arguments to be passed on}
          }
\details{Creates an interaction plot for an MCMCpack regression model. An interaction plot shows the predicted values from a model (y-axis, the outcome variable) for when values on one variable vary (x-axis, the focal variable) at specific values on a third variable (two lines, the fixed variable).

Required are the model, and the focal and fixed variable (as strings).

If the at argument is provided, the predicted values for the focal variable are calculated when the fixed variable is at the two values of the fixed variable specified. This should work for continuous and categorical variables. If no argument is provided, the mimimum and maximum of the fixed variable are used. For categorical variables, the first and the last categories of all unique categories is used.

The uncertainty of the predicted values is shown as a polygon. The probs argument specifies the quantiles. By default a 95\% credibility interval is used (2.5\% and 97.5\% quantiles).

With xlim and ylim the coordinates of the plot can be controlled. A vector with the minimum and maximum value are required in each case.

The argument rug specifies whether a rug plot should be included for the x-axis. A rug plot shows the distribution of observed values, which is particularly relevant for small datasets and variables where the distribution of observations is uneven.

The argument pcol requires a vector with two colours, which are used for the line and polygons of the predicted values. By default, two colours from Tol's colourblind-safe colours are used. The lines are drawn in the colours provided, while the polygons giving the uncertainty are drawn in the colours provided, but with 50\% transparancy (alpha value).

The arguments xlab and ylab are used to specify the labels used. If no labels are given, the function will use "predicted outcome" on the y-axis, and the variable name of the focal variable on the x-axis.

When the provided focal variable is a categorial variable and the fixed variable is a continuous variable, the function shows a warning and automatically switches the focal variable and the fixed variable. It is up to the user to change the interpretation accordingly.

When the focal variable and the fixed variable are categorical variables, the interaction plot draws the predicted values as points (defined by the optional pch argument) and uses a line to show the uncertainty defined by the probs argument. The las argument defines the orientation of the labels on the y-axis, with 2 the default (horizontal).

By default, there are 10 steps calculated: 10 values along the focal variables. For more detailed graphs, choose a higher value, for faster plots a lower value.}
\value{a plot is created}
\author{Didier Ruedin}
\examples{
# Sample data
dat = list(X = c(-2,-1,0,2,2,2,1,2), Y = c(1,1,1,1,3,3,3,5),
           Z = c(1,2,3,5,5,4,2,5), Q = c(2,2,5,2,5,3,3,5))
library(MCMCpack)
m = MCMCregress(Y ~ X*Q + Z, data=dat, mcmc=1000)
iplot(m, focal="X", fixed="Q", probs=c(0.2, 0.8))
}
