\name{mpredict}
\alias{mpredict}
\title{Predict Values for Multiple MCMCpack Regression Models}
\description{Predict values for a regression model for specific values of the variables in the model.}
\usage{mpredict(model, newdata, probs=NULL)}
\arguments{ \item{model}{a regression model created with MCMCpack}
            \item{newdata}{data frame with specific values for each variable in the model}
            \item{probs}{probabilities to illustrate uncertainty}
          }
\details{Designed as a helper function for interaction plots (iplot), this function takes a MCMCpack regression model and a data frame with specific values to predict values for these specific values.

At this stage, only models created with the MCMCregress function are supported. These are linear regression models. The model name is specified without quotes.

The newdata data frame is a data frame where each variable in the regression model is included, alongside a value for this variable. Interaction terms should not be included, they are calculated by the function. The outcome variable should not be included; it is predicted by this function. The function does not include plausibility checks, so the function can predict values that are impossible.

If the data frame with the specific values does not match the number of variables in the model, an error is shown ("Could not calculate predictions. Does newdata match the model?"). It typically helps to modify the data frame to include all variables in the model. Interaction terms are handled automatically and need not be included in the data frame (they are not separate variables for the purpose of this function).

The probs argument can be used to include uncertainty (optional).

The function takes all posterior draws and calculates the predicted value for each draw. The reported value is the mean of these predicted values. If specified, quantiles are reported to indicate uncertainty.
}
\value{predicted value, mean value of all predictions}
\author{Didier Ruedin}
\examples{
# Sample data
dat = list(X = c(-2,-1,0,1,2), Y = c(1,3,3,3,5), Z = c(1,2,3,5,5))
new = data.frame(X = 1, Z = 0.5)
library(MCMCpack)
m = MCMCregress(Y ~ X + Z, data=dat)
mpredict(m, new)
mpredict(m, new, probs=c(0.2, 0.8))
}
