\name{ctable}
\alias{ctable}
\title{Table of coefficients for an MCMCpack regression model}
\description{Extract the coefficients and uncertainty of an MCCMpack regression model, and present it as a simple table.}
\usage{ctable(model, probs=c(0.025, 0.975), intercept=FALSE, vars=NULL,
              names=NULL, digits=2, warning=FALSE, ...)}
\arguments{ \item{model}{regression model created with MCMCregress}
            \item{probs}{probabilities to illustrate uncertainty}
            \item{intercept}{should the intercept be included, defaults to FALSE (intercept not included in plot)}
            \item{vars}{variable names that should be included, optional, defaults to NULL}
            \item{names}{names of the coefficients, optional, defaults to NULL}
            \item{digits}{number of digits to use in the table}
            \item{warning}{should warnings be shown, defaults to FALSE}
            \item{...}{other arguments to be passed on}
}
\details{Creates a simple table of the coefficients in a regression model created with MCMCpack. The name of the model is the only required argument. This function creates a simple table. If desired, it can be styled with the kable function by knitr, for example.

At this stage, only models created with the MCMCregress function are supported. These are linear regression models. The model name is specified without quotes.

The probs argument defines the quantiles of the estimates, by default a 95\% credibility interval. It is possible to use only one quantile or more than two quantiles as arguments.

By default, the intercept is not included (FALSE).

The optional vars argument specifies which variables are included in the coefficient table, and in what order.

If the variable names should be replaced with different text in the table, these can be provided. By default, the variable names are shown in the figure.

The number of digits in the table is controlled with the digits argument. The default is 2.

By default a warning ('Note:') is not shown (warning=FALSE), if chosen, there is a warning if no names are supplied, and variable names are used. This behaviour is intended to encourage meaningful variable names if the output is used to communicate the results to other people. This behaviour may change in future editions.

See also: ctable}
\value{A table is created}
\author{Didier Ruedin}
\examples{
# Sample data
dat = list(X = c(-2,-1,0,1,2), Y = c(1,3,3,3,5), Z = c(1,2,3,5,5))
library(MCMCpack)
m = MCMCregress(Y ~ X + Z, data=dat)
ctable(m)
}
