\name{cplot}
\alias{cplot}
\title{Coefficient Plot for a MCMCpack Regression Model}
\description{Draw a coefficients and uncertainty graphically to better understand regression results in substantive term. The code has only been tested on regresssion models created with the MCMCregress funcition of package MCMCpack.}
\usage{cplot(model, intercept=FALSE, probs=c(0.15865, 0.84135, 0.02275, 0.97725),
             vars=NULL, names=NULL, xlim=NULL, ccolor=NULL, lty=NULL,
             warning=FALSE, adj=0, ...)}
\arguments{ \item{model}{regression model created with MCMCregress}
            \item{intercept}{should the intercept be included, defaults to FALSE (intercept not included in plot)}
            \item{probs}{probabilities to illustrate uncertainty}
            \item{vars}{variable names that should be included, optional, defaults to NULL}
            \item{names}{names of the coefficients, optional, defaults to NULL}
            \item{xlim}{vector of minimum and maximum of the x-axis, optional, defaults to NULL}
            \item{ccolor}{colour of points and lines, optional, defaults to NULL}
            \item{lty}{line type of the lines showing the uncertainty}
            \item{warning}{should warnings be shown, defaults to FALSE}
            \item{adj}{adjustment for lines that are added without underlying plot}
            \item{...}{other arguments to be passed on}
}
\details{Creates a graph of the coefficients in a regression model created with the MCCMregress function in package MCMCpack. The name of the model is the only required argument. Behind the scenes, this functions uses the dotplot function in the graphics package which is part of the basic R installation to avoid overhead, and to increase compatibility with basic R plots.

A coefficient plot is a graphical representation of the coefficients of a regression model and the uncertainty of the estimates. The coefficients are given as dots. To illustrate uncertainty, coefficient plots use lines. This function uses thick and thin lines to illustrate variation in uncertainty and to de-emphasize edges. A vector with four values is required: minimum and maximum of the thicker line, and minimum and maximum of the thinner line. The values use the quantiles function, and the default values correspond to roughly 1 standard error for the thicker line and 2 standard error for the thinner line. The dots show the coefficients.

At this stage, only models created with the MCMCregress function are supported. These are linear regression models. The model name is specified without quotes.

By default, the intercept is not included (FALSE), showing the coefficients (as dots) and uncertainty (as lines).

The optional vars argument specifies which variables are included in the coefficient plot, and in what order.

The intercept can be specified, or if it is left out, intercept=TRUE can be used. By default all the variables shown in the summary are included.

If the variable names should be replaced with different text in the figure, these can be provided. By default, the variable names are shown in the figure.

The xlim argument takes a vector with the minimum and maximum. By default, the range is determined by dotplot.

To increase (or decrease) the width of the lines and the size of the points, the cex argument can be defined. The default is 1. The thick line is twice as thick as the thin line.

Multiple models can be added to a single graphic. After creating the plot with the first model, the adj argument indicates how the lines should be adjusted. Positive values draw the lines above, negative values draw the lines below the first model. If the ccol or lty argument is used at the same time, the additional lines can easily be distinguished and could be labeled in a legend or so.

See also: ctable}
\value{A plot is created.}
\author{Didier Ruedin}
\examples{
# Sample data
dat = list(X = c(-2,-1,0,1,2), Y = c(1,3,3,3,5), Z = c(1,2,3,5,5))
library(MCMCpack)
m = MCMCregress(Y ~ X + Z, data=dat)
cplot(m)
}
