cplot = function(model, intercept=FALSE, probs=c(0.15865, 0.84135, 0.02275, 0.97725), vars=NULL, names=NULL, xlim=NULL, ccolor=NULL, lty=NULL, warning=FALSE, adj=0, ...){
  res = ctable(model, probs=probs, names=names, vars=vars, ..., warning=warning)
  nam = rownames(res)
  xmi = min(res[,4])
  xma = max(res[,5])
  dwhite = par("bg")
  if(is.null(ccolor)) {dblack = par("col")} else {dblack=ccolor}
  dtemp = col2rgb(dblack, alpha=TRUE)
  dgrey = rgb(dtemp[1]/256, dtemp[2]/256, dtemp[3]/256, alpha=0.5)
  if(!adj==0) {
    if(is.null(lty)) {lty=2}
    }
  if(is.null(lty)) {lty=1}       # no lty specified, not adding
  if (adj==0) {
    dotchart(res[,"Mean"], labels=nam, frame.plot=FALSE, pch=19, lcolor=dwhite, xlim=c(xmi, xma), ...)
    abline(v=0, lty=2, col=dgrey)
    }
  len = dim(res)[1]
  cex=par("cex")
  offset=0
  if (!adj==0) {lty=lty} # adding
  for(i in 1:len) {segments(res[,4][i], i+adj, res[,5][i], i+adj, lwd=1*cex, col=dblack, lty=lty)}
  for(i in 1:len) {segments(res[,2][i], i+adj, res[,3][i], i+adj, lwd=2*cex, col=dblack, lty=lty)}
  for(i in 1:len) {points(res[,1][i], i+adj, pch=19, cex=cex, col=dblack)}
}
