% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramnet.R
\name{tramnet}
\alias{tramnet}
\alias{tramnet.formula}
\alias{tramnet.tram}
\title{Regularized transformation models}
\usage{
tramnet(model, ...)

\method{tramnet}{formula}(
  model,
  data,
  lambda,
  alpha,
  tram_fun,
  tram_args = NULL,
  constraints = NULL,
  groups = NULL,
  ...
)

\method{tramnet}{tram}(model, x, lambda, alpha, constraints = NULL, groups = NULL, ...)
}
\arguments{
\item{model}{Either a \code{"formula"} specifying the regression or an object
of class \code{"tram"}.}

\item{...}{Additional arguments passed to \code{\link[CVXR]{solve}}.}

\item{data}{Object of class \code{"data.frame"} containing the variables
referred to in the formula \code{model}.}

\item{lambda}{A positive penalty parameter for the whole penalty function.}

\item{alpha}{A mixing parameter (between zero and one) defining the fraction
between lasso and ridge penalties, where \code{alpha = 1} corresponds to
a pure lasso and \code{alpha = 0} to a pure ridge penalty.}

\item{tram_fun}{Character referring to an implementation in package
\code{'tram'}. See \code{\link[tramnet]{BoxCoxNET}} for the implemented
models.}

\item{tram_args}{Additional arguments (besides \code{model} and \code{data})
passed to \code{tram_fun}.}

\item{constraints}{An optional list containing a matrix of linear inequality
contraints on the regression coefficients and a vector specifying the rhs
of the inequality.}

\item{groups}{For group lasso penalties, groups can be supplied as a vector
of consecutive integers of the same length as columns in \code{x}.}

\item{x}{A numeric matrix, where each row corresponds to the same row in the
\code{data} argument used to fit \code{model}.}
}
\value{
An object of class \code{"tramnet"} with \code{coef}, \code{logLik},
    \code{summary}, \code{simulate}, \code{residuals} and \code{plot} methods
}
\description{
Regularized transformation models
}
\details{
Partially penalized and constrained transformation models,
   including Cox models and continuous outcome logistic regression.
   The methodology is described in the \code{tramnet} vignette
   accompanying this package.
}
\examples{

if (require("penalized") & require("survival")) {
  ## --- Comparison with penalized
  data("nki70", package = "penalized")
  nki70$resp <- with(nki70, Surv(time, event))
  x <- scale(model.matrix( ~ 0 + DIAPH3 + NUSAP1 + TSPYL5 + C20orf46,
                          data = nki70))
  fit <- penalized(response = resp, penalized = x, lambda1 = 1, lambda2 = 0,
                   standardize = FALSE, data = nki70)
  y <- Coxph(resp ~ 1, data = nki70, order = 10, log_first = TRUE)
  fit2 <- tramnet(y, x, lambda = 1, alpha = 1) ## L1 only
  coef(fit)
  coef(fit2)
}

}
\references{
Lucas Kook and Torsten Hothorn, The R Journal (2021) 13:1, pages
   581-594. \doi{10.32614/RJ-2021-054}
}
