% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prof_lambda.R
\name{prof_alpha}
\alias{prof_alpha}
\title{Profiling tuning parameters}
\usage{
prof_alpha(model, min_alpha = 0, max_alpha = 1, nprof = 5, as.lm = FALSE)
}
\arguments{
\item{model}{Object of class \code{"tramnet"}.}

\item{min_alpha}{Minimal value of alpha (default \code{min_alpha = 0}).}

\item{max_alpha}{Maximal value of alpha (default \code{max_alpha = 1}).}

\item{nprof}{Number of profiling steps (default \code{nprof = 5}).}

\item{as.lm}{Return scaled coefficients for class \code{"tramnet_Lm"}.}
}
\value{
Object of class \code{"prof_alpha"} which contains the regularization
    path of all coefficients and the log-likelihood over the mixing parameter
    alpha
}
\description{
Computes the regularization path of all coefficients for a
    single tuning, alpha, parameter over a sequence of values.
}
\examples{
\donttest{
if (require("survival") & require("penalized")) {
  data("nki70", package = "penalized")
  nki70$resp <- with(nki70, Surv(time, event))
  x <- scale(model.matrix( ~ 0 + DIAPH3 + NUSAP1 + TSPYL5 + C20orf46, data = nki70))
  y <- Coxph(resp ~ 1, data = nki70, order = 10, log_first = TRUE)
  fit <- tramnet(y, x, lambda = 1, alpha = 1)
  pfa <- prof_alpha(fit)
  plot_path(pfa)
}
}

}
