% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prof_lambda.R
\name{plot_path}
\alias{plot_path}
\title{Plot regularization paths}
\usage{
plot_path(object, plot_logLik = FALSE, ...)
}
\arguments{
\item{object}{Object of class \code{"prof_alpha"} or \code{"prof_lambda"}.}

\item{plot_logLik}{Whether \code{logLik} trajectory should be plotted
(default \code{plot_logLik = FALSE}).}

\item{...}{Additional arguments to \code{\link{plot}}}
}
\value{
None.
}
\description{
Plot regularization paths and optionally log-likelihood
    trajectories of objects of class \code{"prof_alpha"} and
    \code{"prof_lambda"}. Coefficient names are automatically added to the
    plot.
}
\examples{
\donttest{
if (require("survival") & require("penalized")) {
  data("nki70", package = "penalized")
  nki70$resp <- with(nki70, Surv(time, event))
  x <- scale(model.matrix( ~ 0 + DIAPH3 + NUSAP1 + TSPYL5 + C20orf46, data = nki70))
  y <- Coxph(resp ~ 1, data = nki70, order = 10, log_first = TRUE)
  fit1 <- tramnet(y, x, lambda = 0, alpha = 1)
  pfl <- prof_lambda(fit1)
  plot_path(pfl)
  fit2 <- tramnet(y, x, lambda = 1, alpha = 1)
  pfa <- prof_alpha(fit2)
  plot_path(pfa)
}
}

}
