% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias.R
\name{LmNET}
\alias{LmNET}
\alias{BoxCoxNET}
\alias{ColrNET}
\alias{SurvregNET}
\alias{CoxphNET}
\alias{LehmannNET}
\alias{PolrNET}
\title{Regularized transformation model classes}
\usage{
LmNET(
  formula,
  data,
  lambda = 0,
  alpha = 1,
  tram_args = NULL,
  constraints = NULL,
  ...
)

BoxCoxNET(
  formula,
  data,
  lambda = 0,
  alpha = 1,
  tram_args = NULL,
  constraints = NULL,
  ...
)

ColrNET(
  formula,
  data,
  lambda = 0,
  alpha = 1,
  tram_args = NULL,
  constraints = NULL,
  ...
)

SurvregNET(
  formula,
  data,
  lambda = 0,
  alpha = 1,
  tram_args = NULL,
  constraints = NULL,
  ...
)

CoxphNET(
  formula,
  data,
  lambda = 0,
  alpha = 1,
  tram_args = NULL,
  constraints = NULL,
  ...
)

LehmannNET(
  formula,
  data,
  lambda = 0,
  alpha = 1,
  tram_args = NULL,
  constraints = NULL,
  ...
)

PolrNET(
  formula,
  data,
  lambda = 0,
  alpha = 1,
  tram_args = NULL,
  constraints = NULL,
  ...
)
}
\arguments{
\item{formula}{Formula specifying the regression. See \code{\link[tram]{tram}}.}

\item{data}{Object of class \code{"data.frame"} containing the variables
referred to in the formula \code{model}.}

\item{lambda}{A positive penalty parameter for the whole penalty function.}

\item{alpha}{A mixing parameter (between zero and one) defining the fraction
between lasso and ridge penalties, where \code{alpha = 1} corresponds to
a pure lasso and \code{alpha = 0} to a pure ridge penalty.}

\item{tram_args}{Additional arguments (besides \code{model} and \code{data})
passed to \code{tram_fun}.}

\item{constraints}{An optional list containing a matrix of linear inequality
contraints on the regression coefficients and a vector specifying the rhs
of the inequality.}

\item{...}{Additional arguments passed to \code{\link[CVXR]{solve}}.}
}
\value{
Object of class \code{"tramnet"}.
}
\description{
Regularized transformation model classes
}
