% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{logLik.tramnet}
\alias{logLik.tramnet}
\alias{coef.tramnet}
\alias{coef.tramnet_Lm}
\alias{predict.tramnet}
\alias{simulate.tramnet}
\alias{estfun.tramnet}
\alias{residuals.tramnet}
\alias{print.tramnet}
\alias{summary.tramnet}
\alias{print.summary.tramnet}
\title{S3 methods for class \code{"tramnet"}}
\usage{
\method{logLik}{tramnet}(
  object,
  parm = coef(object, tol = 0, with_baseline = TRUE),
  w = NULL,
  newdata = NULL,
  add_penalty = FALSE,
  ...
)

\method{coef}{tramnet}(object, with_baseline = FALSE, tol = 1e-06, ...)

\method{coef}{tramnet_Lm}(object, with_baseline = FALSE, tol = 1e-06, as.lm = FALSE, ...)

\method{predict}{tramnet}(object, newdata = NULL, ...)

\method{simulate}{tramnet}(object, nsim = 1, seed = NULL, newdata = NULL, bysim = TRUE, ...)

\method{estfun}{tramnet}(
  x,
  parm = coef(x, with_baseline = TRUE, tol = 0),
  w = NULL,
  newdata = NULL,
  ...
)

\method{residuals}{tramnet}(
  object,
  parm = coef(object, tol = 0, with_baseline = TRUE),
  w = NULL,
  newdata = NULL,
  ...
)

\method{print}{tramnet}(x, ...)

\method{summary}{tramnet}(object, ...)

\method{print}{summary.tramnet}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{Object of class \code{"tramnet"}.}

\item{parm}{Parameters to evaluate the log likelihood at.}

\item{w}{Optional vector of sample weights.}

\item{newdata}{Data to evaluate the log likelihood at.}

\item{add_penalty}{Whethr or not to return the penalized log-likelihood
(default \code{add_penalty = FALSE}).}

\item{...}{Ignored.}

\item{with_baseline}{If \code{TRUE}, also prints coefficients for the
baseline transformation.}

\item{tol}{Tolerance when an estimate should be considered 0 and not
returned (default \code{tol = 1e-6}).}

\item{as.lm}{See \code{\link[mlt]{coef.mlt}}}

\item{nsim}{Number of simulations, see \code{\link[mlt]{simulate.mlt}}.}

\item{seed}{Random seed, see \code{\link[mlt]{simulate.mlt}}.}

\item{bysim}{Return by simulation, see \code{\link[mlt]{simulate.mlt}}.}

\item{x}{Object of class \code{"tramnet"}.}

\item{digits}{Number of digits to print.}
}
\value{
Returns (potentially weighted \code{w}) log-likelihood based on
\code{object} evaluated at parameters \code{parm} and data \code{newdata}

Numeric vector containing the model shift parameter estimates

Numeric vector containing the linear model shift parameter estimates

Vector of predictions based on \code{object} evaluated at each row
of \code{newdata}

Returns a \code{list} of \code{data.frames} containing parametric
    bootstrap samples of the response based on the data supplied in
    \code{newdata}

Matrix of score contributions w.r.t. model parameters evaluated at
    \code{parm}

Returns a numeric vector of residuals for each row in \code{newdata}

Object of class \code{"summary.tramnet"}.

Object of class \code{"summary.tramnet"}.

Invisible \code{x}.
}
\description{
S3 methods for class \code{"tramnet"}
}
