% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramnet_mbo.R
\name{mbo_tramnet}
\alias{mbo_tramnet}
\title{Model based optimization for regularized transformation models}
\usage{
mbo_tramnet(
  object,
  fold = 2,
  n_iter = 5,
  minlambda = 0,
  maxlambda = 16,
  minalpha = 0,
  maxalpha = 1,
  folds = NULL,
  noisy = FALSE,
  obj_type = c("lasso", "ridge", "elnet"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{Object of class \code{"tramnet"}.}

\item{fold}{Number of cross validation folds.}

\item{n_iter}{Maximum number of iterations in model-based optimization
routine.}

\item{minlambda}{Minimum value for lambda (default \code{minlambda = 0}).}

\item{maxlambda}{Maximum value for lambda (default \code{maxlambda = 16}).}

\item{minalpha}{Minimum value for alpha (default \code{minalpha = 0}).}

\item{maxalpha}{Maximum value for alpha (default \code{maxalpha = 1}).}

\item{folds}{Self specified folds for cross validation (mainly for
reproducibility and comparability purposes).}

\item{noisy}{indicates whether folds for k-fold cross-validation should
be random for each iteration, leading to a noisy objective function
(default \code{noisy = FALSE}).}

\item{obj_type}{Objective type, one of \code{"lasso"}, \code{"ridge"} or
\code{"elnet"}.}

\item{verbose}{Toggle for a verbose output (default \code{verbose = TRUE})}

\item{...}{Currently ignored.}
}
\value{
See \code{\link[bbotk]{Optimizer}}'s \code{optimize} function which
    returns a \code{data.table::data.table}.
}
\description{
Uses model based optimization to find the optimal tuning
    parameter(s) in a regularized transformation model based on
    cross-validated log-likelihoods. Here the \code{'tramnet'} package makes
    use of the \code{'mlr3mbo'} interface for Bayesian Optimization in
    machine learning problems to maximize the cv-logLik as a black-box
    function of the tuning parameters alpha and lambda.
}
