\name{mcoef}
\alias{mcoef}
\title{Extracts Coefficients from an MCMCpack Regression Model}
\description{Extracts coefficients from an MCMCpack regression model}
\usage{mcoef(model)}
\arguments{ \item{model}{regression model created with MCMCpack}
          }
\details{This function extracts the coefficients from an MCCMpack regression model. Behind the scenes, it calls ctable without intercept and without uncertainty (probs=0).}
\value{coefficients from the regression model}
\author{Didier Ruedin}
\examples{
# Sample data
dat = data.frame(X = c(-2,-1,0,1,2), Y = c(1,3,3,3,5), Z = c(1,2,3,5,5))
library(MCMCpack)
m = MCMCregress(Y ~ X + Z, data=dat)
mcoef(m)
}
