ctable = function(model, probs=c(0.025, 0.975), intercept=FALSE, vars=NULL, names=NULL, digits=2, warning=FALSE, ...) {
  posterior = data.frame(as.matrix(model))                      # samples
  mea = apply(posterior, FUN=mean, MARGIN=2)                    # mean
  cin = apply(posterior, FUN=quantile, probs=probs, MARGIN=2)   # range
  tab = round(t(rbind(mea, cin)), digits)                       # combine results
  rou = 0                                                       # rounding for column
  if (probs[1] < 0.05)   {rou = 1}                              # making rounding dynamic
  if (probs[1] < 0.005)  {rou = 2}
  if (probs[1] < 0.0005) {rou = 3}
  colnames(tab) = c("Mean", paste0(as.character(round(probs*100, rou)), "%"))
  rownames(tab) = rownames(summary(model)$statistics)           # get from summary.mcmc
  tab = tab[1:(dim(tab)[1]-1), ]                                # remove sigma2 from results
  if(intercept==FALSE) {                                        # remove intercept in names if chosen
    tab = tab[2:(dim(tab)[1]), ]
    }
  if(is.null(vars)) {                                           # variables not supplied; use name
    # nothing to do here
    } else {                                                    # variables supplied
    tab = tab[vars,]
    }
  if(is.null(names)) {                                          # no names supplied
    if (warning==TRUE) {message("Note: names not supplied, using variable names")}   # no change
    } else {
    nnam = length(names)                                        # number of names supplied
    nvar = dim(tab)[1]                                          # number of variables in table
    if((nvar-nnam) == 1) {names = c("(Intercept)", names)}      # quietly add intercept if not stated
    rownames(tab) = names                                       # use names supplied
    }
  return(tab)
}
