% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struc_vec.R
\name{struc_vec}
\alias{struc_vec}
\title{Function to calculate the structure vector matrix X* for categorical outcomes.}
\usage{
struc_vec(y, X, label = TRUE, rational = FALSE)
}
\arguments{
\item{y}{an outcome variable. Should be a factor else we order increasingly in an alpha-numeric fashion.}

\item{X}{a design matrix, e.g. generated via a call to \code{model.matrix} or via the function \code{make_yx}. This means we expect that \code{X} already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{label}{should the structure vector matrix have row and column labels?}

\item{rational}{should the matrices be returned in rational format?}
}
\value{
a matrix of structure vectors with or without labels
}
\description{
Function to calculate the structure vector matrix X* for categorical outcomes.
}
\details{
If \code{X} is given as the standard R object for design matrices (i.e., a numeric matrix), the structure vector matrix is returned the same way unless \code{rational=TRUE}; then it is returned as a character matrix of rational numbers. If \code{X} is given in rational format, it is also returned as rational format even if rational is set to \code{FALSE}. This returned matrix is like \code{-nomin_Xstar(y,X)}.
}
