% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepobs_sl.R
\name{sepobs_sl}
\alias{sepobs_sl}
\alias{detect_sepobs_sl}
\title{Detect observations with separation for sequential (continuation-ratio) ordinal response models.}
\usage{
sepobs_sl(y, X, rational = FALSE, reduce = TRUE)

detect_sepobs_sl(y, X, rational = FALSE, reduce = TRUE)
}
\arguments{
\item{y}{the ordinal outcome variable. Works best if it is an ordered factor but can also be numeric, boolean or character. In the latter case we internally coerce to ordered factor interpret the ordering as alphanumerically increasing (just as as.ordered is doing).}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{should rational arithmetic be used?}

\item{reduce}{should the results be pooled over all categories? Defaults to TRUE.}
}
\value{
if reduce = TRUE a list with the list elements being a list of
\itemize{
\item offobs the submatrix of the matrix (X,y) with the observations responsible over all categories
\item index the index of the separated observations over all categories 
}'
if reduce = FALSE a list of lists with a list for each category listing offobs and index as above but category specific
}
\description{
Detect observations with separation for sequential (continuation-ratio) ordinal response models.
}
\examples{
data(qcsepdato)
y<-qcsepdato$y
X<-qcsepdato[,2:ncol(qcsepdato)]
sepobs_sl(y,X)

}
