% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepobs_osm.R
\name{sepobs_osm}
\alias{sepobs_osm}
\alias{detect_sepobs_osm}
\title{Identify the observations that cause separation in ordered stereotype models.}
\usage{
sepobs_osm(y, X, rational = FALSE)

detect_sepobs_osm(y, X, rational = FALSE)
}
\arguments{
\item{y}{the ordinal outcome variable. Works best if it is an ordered factor but can also be numeric, boolean or character. In the latter case we corece to ordered factor and interpret the ordering as alphanumerically increasing (just as as.ordered is doing).}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{should rational arithmetic be used?}
}
\value{
a list with elements: 
\itemize{
\item offobs the submatrix of the matrix (X,y) with the observations responsible 
\item index the index of the separated observations  
}
}
\description{
This function checks which observations are responsible for separation on any category.
}
\examples{
data(qcsepdatm)
y<-qcsepdatm$y
X<-qcsepdatm[,2:ncol(qcsepdatm)]
sepobs_osm(y,X)

}
