% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepobs_cl.R
\name{sepobs_cl}
\alias{sepobs_cl}
\alias{detect_sepobs_cl}
\title{Identify the observations that cause separation in cumulative link ordinal response models.}
\usage{
sepobs_cl(y, X, rational = FALSE)

detect_sepobs_cl(y, X, rational = FALSE)
}
\arguments{
\item{y}{the ordinal outcome variable. Works best if it is an ordered factor but can also be numeric, boolean or character. In the latter case we corece to ordered factor and interpret the ordering as alphanumerically increasing (just as as.ordered is doing).}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{should rational arithmetic be used?}
}
\value{
a list with elements: 
\itemize{
\item offobs the submatrix of the matrix (X,y) with the observations responsible 
\item index the index of the separated observations  
}
}
\description{
This function checks which observations are responsible for separation. It does this over all categories, so the observations need not separate the same categories.
}
\examples{
data(qcsepdato)
y<-qcsepdato$y
X<-qcsepdato[,2:ncol(qcsepdato)]
sepobs_cl(y,X)

}
