% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepobs_bcl.R
\name{sepobs_bcl}
\alias{sepobs_bcl}
\alias{detect_sepobs_bcl}
\title{Identify the observations that cause separation in baseline-category link categorical response models.}
\usage{
sepobs_bcl(y, X, rational = FALSE)

detect_sepobs_bcl(y, X, rational = FALSE)
}
\arguments{
\item{y}{the ordinal outcome variable. Works best if it is an ordered factor but can also be numeric, boolean or character. In the latter case we corece to ordered factor and interpret the ordering as alphanumerically increasing (just as as.ordered is doing).}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{should rational arithmetic be used?}
}
\value{
a list with elements: 
\itemize{
\item offobs the submatrix of the matrix (X,y) with the observations responsible for separaton on in any category.
\item index the index of the observations.
}
}
\description{
This function checks which observations are responsible for separation on any category. The observations need not separate the same categories.
}
\examples{
data(qcsepdatm)
y<-qcsepdatm$y
X<-qcsepdatm[,2:ncol(qcsepdatm)]
sepobs_bcl(y,X)

}
