% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepobs_b.R
\name{sepobs_b}
\alias{sepobs_b}
\alias{detect_sepobs_b}
\title{Observations that cause separation in binary outcomes.}
\usage{
sepobs_b(y, X, rational = FALSE)

detect_sepobs_b(y, X, rational = FALSE)
}
\arguments{
\item{y}{the binary outcome variable. Works best if it is a factor or ordered factor but can also be numeric, boolean or character. We coerce to factor internally.}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{should rational arithmetic be used.}
}
\value{
a list with elements: 
\itemize{
\item offobs the submatrix of the matrix (X,y) with the observations responsible 
\item index the index of the separated observations  
}'
}
\description{
This function checks which observations casue the separation (or none)
}
\examples{
data(csepdat1)
y<-csepdat1$y
X<-cbind(1,csepdat1[,2:ncol(csepdat1)])
sepobs_b(y,X) #separation
}
