% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reccone.R
\name{reccone_sl}
\alias{reccone_sl}
\title{Calculates recession cone for sequential link models.}
\usage{
reccone_sl(y, X, rational = FALSE, reduced = TRUE)
}
\arguments{
\item{y}{the outcome variable. Works best if it is a factor or ordered factor but can also be numeric, boolean or character.}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{boolean flag whether rational arithmetic should be used. Default is FALSE.}

\item{reduced}{if TRUE the result is pooled over all the categories and FALSE it is per category.}
}
\value{
a list (or list of lists if 'reduced=FALSE') with 'cone' being the recession cone over all categories ('reduced=TRUE') or per category ('reduced=FALSE'), 'reccdim' being the dimension of the recession cone for each category (reduced=FALSE) or the dimension of the largest recession cone of any category ('reduced=TRUE'), and 'index' the row index of the structure vectors that are not linearities for each category ('reduced=FALSE') or over all categories ('reduced=TRUE'). Note that in case of 'X' not having full column rank, the 'reccdim' value is the dimension of the recession cone due to separation plus the number of columns that are linear dependent.
}
\description{
This function returns the structure vectors that are not linearities (comprising the recession cone), the recession cone dimension and the row index of the structure vectors that are not linearities (mnaking up the recession cone).
}
