% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reccone.R
\name{reccone}
\alias{reccone}
\title{Calculates recession cone for categorical data models.}
\usage{
reccone(y, X, rational = FALSE, model = c("b", "bcl", "acl", "sl", "osm"))
}
\arguments{
\item{y}{the outcome variable. Works best if it is a factor or ordered factor but can also be numeric, boolean or character.}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{boolean flag whether rational arithmetic should be used. Default is FALSE.}

\item{model}{which model is the check for? One of bcl (baseline-category link), acl (adjacent-category link), b (binary), osm (ordered stereotype model), sl (sequential aka continuation-ratio link).}
}
\value{
a list with 'cone' being the recession cone, 'reccdim' being the dimensions of the recession cone, and 'index' the row index of the structure vectors that are not linearities. Note that in case of 'X' not having full column rank, the 'reccdim' value is the dimension of the recession cone due to separation plus the number of columns that are linear dependent.
}
\description{
This function returns the structure vectors that are not linearities (comprising the recession cone), the recession cone dimension and the row index of the structure vectors that are not linearities (mnaking up the recession cone).
}
