% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_fc.R
\name{overlap_fc}
\alias{overlap_fc}
\title{A fraction check for overlap.}
\usage{
overlap_fc(
  y,
  X,
  frac = 10L,
  verbose = FALSE,
  rational = FALSE,
  model = c("b", "bcl", "cl", "acl", "sl", "osm")
)
}
\arguments{
\item{y}{outcome vector.}

\item{X}{design matrix.}

\item{frac}{the fraction of the data to use for checking (uses n/frac data). Defaults to 10. If frac is below 1 or n, it uses frac=1. Using frac=1 is the same as using check_ovl.}

\item{verbose}{should progress be reported. Defaults ot 'FALSE'.}

\item{rational}{should rational arithmetic be used?}

\item{model}{what model class is intended to be fitted? Can be any of "b" for binary, "bcl" for baseline-category link, "cl" for cumulative link, "acl" for adjacent-category link. "sl" for sequential link, "osm" for ordered stereotype model. If missing it defaults to cumulative link for ordinal y and baseline-category for everything else.}
}
\value{
a Boolean; either 'TRUE' if we detect overlap or 'FALSE' if we do not (so the data show separation).
}
\description{
Intended for data where one suspects overlap, this function checks for overlap on an ever growing subset of the data. It is a low-level function for a response vector y and a design matrix X.
}
\details{
The function samples a fraction of observations form the data and checks for overlap. If overlap exists in a subset, then overlap exists in the overal data (Corollary in Sablica et al,. (2025)). If no overlap is found, it takes a larger sample and checks again until all data are tested. If no overlap is found even for all data, it concludes there is separation.

Since solving the exact linear program on the full data via \link{check_ovl} can take a long time for large data, this check can be quicker in case of overlap (especially if the overlapping categories are not rare). However, if there is separation this function usually takes longer.
}
