% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearities.R
\name{linearities_sl}
\alias{linearities_sl}
\title{This function calculates the linearities in the data for an sequential link model, so the row vectors for which there is no separation. If this is an empty set or of length 0, then we have overlap.}
\usage{
linearities_sl(y, X, rational = FALSE, reduced = TRUE)
}
\arguments{
\item{y}{the outcome variable. Can be factor, ordered, numeric, character or boolean. Works best if it is a factor or ordered factor. If it is not an (ordered) factor, we treat the outcome as nominal.}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{boolean flag whether rational arithmetic should be used. Default is FALSE}

\item{reduced}{If TRUE (default) the per category results are merged into one objct and duplicates removed. If FALSE, the result is given for each category separately.}
}
\value{
a list with elements $linX which lists the rows vectors that are linearities for any category (reduced=TRUE) or by category (reduced=FALSE), and $index which gives the row index of the linearities for any or by category. If there is complete separation they are both empty set. If their length/row dimension is number of categories*dim(X)[1], there is overlap. Anything in between is quasi-complete separation.
}
\description{
This function calculates the linearities in the data for an sequential link model, so the row vectors for which there is no separation. If this is an empty set or of length 0, then we have overlap.
}
