% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagsep_bcl.R
\name{diagsep_bcl}
\alias{diagsep_bcl}
\title{Detailed separation diagnostic for baseline-category link models.}
\usage{
diagsep_bcl(y, X, rational = FALSE)
}
\arguments{
\item{y}{the nominal outcome variable. Works best if it is a factor but can also be numeric, boolean or character. In the case of the latter we coerce to factor and the lowest alphanumeric entry is used as reference (just as 'as.ordered' is doing).}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{should rational arithmetic be used.}
}
\value{
an object of class 'sepmod' that is a list with the components:
\itemize{
\item separation boolean whether there is separation ('TRUE' means separation)
\item septype which type of separation (or not). A string of either "Overlap", "Quasi-Complete Separation" or "Complete Separation".
\item reccdim dimension of recession cone
\item offobs offending observations 
\item nr.offcols number of columns of the design matrix that have separation
\item offcols columns of the design matrix that have separation. It is given as category::effect.  
}
}
\description{
This function checks whether there is (quasi-) complete separation, which type if any, gives the dimension of the recession cone, lists the number of columns in the design matrix that give rise to the separation as well as the columns names and lists the observations for which we have separation.
}
\examples{
data(qcsepdatm)
y<-qcsepdatm$y
X<-qcsepdatm[,2:ncol(qcsepdatm)]
diagsep_bcl(y,X)

}
