% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagsep_b.R
\name{diagsep_b}
\alias{diagsep_b}
\title{Detailed separation diagnostic for binary outcomes.}
\usage{
diagsep_b(y, X, rational = FALSE)
}
\arguments{
\item{y}{the binary outcome variable. Works best if it is a factor or ordered factor but can also be numeric, boolean or character. We coerce to factor internally.}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{should rational arithmetic be used.}
}
\value{
an object of class 'sepmod' that is a list with the components:
\itemize{
\item separation boolean whetehr there is separation ('TRUE' means separation)
\item septype which type of separation (or not). A string of either "Overlap", "Quasi-Complete Separation" or "Complete Separation".
\item reccdim dimension of recession cone
\item offobs offending observations 
\item nr.offcols number of columns of X that have separation
\item offcols columns of X that have separation
}
}
\description{
This function checks whether there is (quasi-) complete separation, which type if any, gives the dimension of the recession cone, lists the number of columns in the design matrix that give rise to the separation as well as the columns names and lists the observations for which we have separation.
}
\examples{
data(csepdat1)
y<-csepdat1$y
X<-cbind(1,csepdat1[,2:ncol(csepdat1)])
diagsep_b(y,X) #separation
}
