% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagsep_acl.R
\name{diagsep_acl}
\alias{diagsep_acl}
\title{Detailed separation diagnostic for adjacent-category link ordinal response models.}
\usage{
diagsep_acl(y, X, rational = FALSE)
}
\arguments{
\item{y}{the ordinal outcome variable. Works best if it is an ordered factor but can also be numeric, boolean or character. In the latter case we coerce to ordered factor and interpret the ordering as alphanumerically increasing (just as 'as.ordered' is doing).}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{should rational arithemtic be used?}
}
\value{
an object of class 'sepmod' that is a list with the components:
\itemize{
\item separation boolean whether there is separation ('TRUE' means separation)
\item septype which type of separation (or not). A string of either "Overlap", "Quasi-Complete Separation" or "Complete Separation".
\item reccdim dimension of recession cone
\item offobs offending observations, the ones which are not linearities  (note that individual observations can be duplicated in the cone as they may lie on the boundary) 
\item nr.offcols number of columns of the design matrix that have separation
\item offcols columns of the design matrix that have separation. It is given as category::effect.  
}
}
\description{
This function checks whether there is (quasi-) complete separation, which type if any, gives the dimension of the recession cone, lists the number of columns in the design matrix that give rise to the separation as well as the columns names and lists the observations for which we have separation.
}
\examples{
data(qcsepdato)
y<-qcsepdato$y
X<-qcsepdato[,2:ncol(qcsepdato)]
diagsep_acl(y,X)

}
