% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagsep.R
\name{diagsep}
\alias{diagsep}
\title{Detailed separation diagnostic for all categorical outcomes.}
\usage{
diagsep(y, X, rational = FALSE, model = c("bcl", "cl", "acl", "sl", "osm"))
}
\arguments{
\item{y}{the outcome variable. Can be binary, categorial or ordinal. Works best if it is an ordered or unordered factor but can also be numeric, boolean or character. If y is not a factor, it is treated as a nominal (categorical) outcome.}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{should rational arithmetic be used?}

\item{model}{what model class is intended to be fitted? Can be any of "b" for binary, "bcl" for baseline-category link, "cl" for cumulative link, "acl" for adjacent-category link. "sl" for sequential link, "osm" for ordered stereotype model. If missing it defaults to cumulative link for ordinal y and baseline-category for everything else.}
}
\value{
an object of class 'sepmod' that is a list with the components:
\itemize{
\item separation boolean whether there is separation ('TRUE' means separation)
\item septype which type of separation (or not). A string of either "Overlap", "Quasi-Complete Separation" or "Complete Separation".
\item reccdim dimension of recession cone
\item offobs offending observations 
\item nr.offcols number of columns of the design matrix that have separation
\item offcols columns of the design matrix that have separation. It is given as category::effect.  
}
}
\description{
This function checks whether there is (quasi-) complete separation, which type if any, gives the dimension of the recession cone, lists the number of columns in the design matrix that give rise to the separation as well as the columns names and lists the observations for which we have separation.
}
\examples{
data(qcsepdatm)
y<-qcsepdatm$y
X<-cbind(1,qcsepdatm[,2:ncol(qcsepdatm)])
diagsep(y,X,model="bcl")

}
