% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_sepcols.R
\name{detect_sepcols_b}
\alias{detect_sepcols_b}
\alias{sepcols_b}
\title{This function identifies the columns in a binary model design matrix that are responsible for separation.}
\usage{
detect_sepcols_b(y, X, rational = FALSE)

sepcols_b(y, X, rational = FALSE)
}
\arguments{
\item{y}{the dependent variable. Must be binary. If we encounter a factor, we use the levels of the factor and thus also the specified reference. For anything else, we use the lowest alphanumeric category as reference.}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynominals).}

\item{rational}{should rational arithmetic be used.}
}
\description{
This function identifies the columns in a binary model design matrix that are responsible for separation.
}
\details{
We solve a linear program in this function that operates only on y and X, so without a specific model. This program corresponds to detecting which columns in the design matrix leads to infinite MLE for some link functions, but it is more general as there are links that can still give finite estimates even though there is separation. Hence this function detects separation even in the case of (seemingly) finite estimates or if there is no warning. The prime example is using the log link in logistic regression.
}
