% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_sepcols.R
\name{detect_sepcols_acl}
\alias{detect_sepcols_acl}
\alias{sepcols_acl}
\title{This function identifies the columns in a design matrix for an adjacent-category link model that have an infinite MLE, due to separation. Note this is due to separation which includes the case of a design matrix that doesn't have full rank.}
\usage{
detect_sepcols_acl(y, X, rational = FALSE)

sepcols_acl(y, X, rational = FALSE)
}
\arguments{
\item{y}{the outcome variable. Can be factor, ordered, numeric, character or boolean. Works best if it is a factor or ordered factor. If it is not an (ordered) factor, we treat the outcome as nominal.}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{rational}{boolean flag whether rational arithmetic should be used. Default is FALSE.}
}
\description{
This function identifies the columns in a design matrix for an adjacent-category link model that have an infinite MLE, due to separation. Note this is due to separation which includes the case of a design matrix that doesn't have full rank.
}
\details{
We solve a linear program in this function that operates only on y and X, so without a specific model. This program corresponds to detecting which columns in the design matrix leads to infinite MLE for some link functions, but it is more general as there are links that can still give finite estimates even though there is separation. Hence this function detects separation even in the case of (seemingly) finite estimates or if there is no warning. The prime example is using the log link in logistic regression.
}
