% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_sepcols.R
\name{detect_sepcols}
\alias{detect_sepcols}
\alias{sepcols}
\title{This function identifies the columns in a design matrix that are responsible for separation. It calls lower level functions if given an argument or chooses based on the response type.}
\usage{
detect_sepcols(
  y,
  X,
  rational = FALSE,
  model = c("bcl", "cl", "acl", "sl", "osm")
)

sepcols(y, X, rational = FALSE, model = c("bcl", "cl", "acl", "sl", "osm"))
}
\arguments{
\item{y}{the dependent variable.}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynominals).}

\item{rational}{Should rational arithmetic be used?}

\item{model}{the model type. If not given, we default to cumulativie link for ordered factors and baseline-category for everything else.}
}
\description{
This function identifies the columns in a design matrix that are responsible for separation. It calls lower level functions if given an argument or chooses based on the response type.
}
\details{
We solve a linear program in this function that operates only on y and X, so without a specific model. This program corresponds to detecting which columns in the design matrix leads to infinite MLE for some link functions, but it is more general as there are links that can still give finite estimates even though there is separation. Hence this function detects separation even in the case of (seemingly) finite estimates or if there is no warning. The prime example is using the log link in logistic regression.

This function assumes that either a baseline-category link model for categorical outcomes (incl. binary )is wanted, or a cumulative link model for ordinal outcomes. For adjacent-category link, sequential link or ordered stereotypes models use the subfunctions detect_sepcols_acl, detect_sepcols_sl and detect_sepcols_os respectively.
}
