% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_bseq.R
\name{create_bseq}
\alias{create_bseq}
\title{Creates a list of data for a sequence of binary models from a sequential (continuation ratio) model. It splits the data according to the forward sequential mechanism.}
\usage{
create_bseq(y, X)
}
\arguments{
\item{y}{the ordinal outcome variable with m categories. Works best if it is a factor but can also be numeric, boolean or character. In the later case we interpret the ordering as alphanumerically increasing (just like as.ordered is doing).}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}
}
\value{
a list of length m-1 that separates the input into y and X tupels according to the sequential model mechanism.
}
\description{
Creates a list of data for a sequence of binary models from a sequential (continuation ratio) model. It splits the data according to the forward sequential mechanism.
}
\details{
The sequential mechanism is so that or category k (running from 1 to m-1) all i for which y_i>=k are selected. All y_i>k are given a value of 0 and y_i=k a value of 1.
}
