% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcl_Xstar.R
\name{bcl_Xstar}
\alias{bcl_Xstar}
\title{Function to calculate the structure vector matrix X* for baseline-category outcomes.}
\usage{
bcl_Xstar(y, X, label = TRUE, rational = FALSE)
}
\arguments{
\item{y}{a nominal or binary outcome variable. Works best if it is a factor but can also be numeric, boolean or character.}

\item{X}{a design matrix, e.g. generated via a call to \code{model.matrix} or via the function \code{make_yx}. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials).}

\item{label}{should the structure vector matrix have row and column labels?}

\item{rational}{should the structure vectors been given in rational format?}
}
\value{
a matrix of structure vectors with or without labels.
}
\description{
Function to calculate the structure vector matrix X* for baseline-category outcomes.
}
\details{
If \code{X} is given as the standard R object for design matrices (i.e., a numeric matrix), they are returned the same way unless \code{rational=TRUE}; then it is returned as a character matrix of rational numbers. If \code{X} is given in rational format, it is also returned as rational format even if rational is set to \code{FALSE}. This returned matrix is like \code{-struc_vec(y,X)}.
}
