% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acl_XStar.R
\name{acl_Xstar}
\alias{acl_Xstar}
\title{Function to calculate the structure vector matrix X* for an adjacent-category link model.}
\usage{
acl_Xstar(y, X, label = TRUE, rational = FALSE)
}
\arguments{
\item{y}{an ordinal outcome variable. Should be an ordered factor else we order increasingly in an alpha-numeric fashion.}

\item{X}{a design matrix, e.g. generated via a call to 'model.matrix'. This means we expect that X already contains the desired contrasts for factors (e.g., dummies) and any other expanded columns (e.g., for polynomials). For this function we also assume the X to either have an intercept column labeled with a string as *ntercept*, or not having an intercept column.}

\item{label}{should the structure vector matrix have row and column labels?}

\item{rational}{should the structure vectors been given in rational format?}
}
\value{
a matrix of structure vectors with or without labels
}
\description{
Function to calculate the structure vector matrix X* for an adjacent-category link model.
}
\details{
If \code{X} is given as the standard R object for design matrices (i.e., a numeric matrix) or as a data frame, they are returned the same way unless \code{rational=TRUE}; then it is returned as a character matrix of rational numbers. If \code{X} is given in rational format, it is also returned as rational format even if rational is set to \code{FALSE}.
}
