% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSS-data.R
\docType{data}
\name{HDSS}
\alias{HDSS}
\title{Willingness to Share Health Data of Drexler (2025)}
\format{
A 300 x 5 data frame:  
\describe{
  \item{ID}{An ID (not the original one from the study).}
  \item{WSTSSHI}{Item: Willingness to share personal health information with the social health insurance provider. An ordered factor with 1 indicating lowest willingness and 4 highest willingness.}
  \item{knowledge}{Item: Knowledge about health data. An ordinal scale from 1 to 4 with 1 being the lowest knowledge and 4 highest knowledge.}
  \item{chronic}{Number of chronic conditions (1 meaning "yes, one" 2 meaning "yes, many" and 3 meaning "none").}
  \item{trustSHI}{Item: Trust in the social health insurance provider. An ordinal scale from 1 to 4 with 1 being the lowest trust and 4 highest trust.}
  \item{gender}{A person's gender identification with levels "f" for female, "m" for male and "x" for neither.}
}
}
\source{
Drexler, S. (2025), "Facilitators for sharing patient-reported measures: a mixed-methods study".
}
\usage{
data(HDSS)
}
\description{
These data are a snapshot from a study on willingness to share health data in Austria. We look at the willingness to share data with a social health insurance provider for people with chronic conditions. The data is a random sample of 300 observations from the original 795 and fully anonymized. We did the following data preparation steps over the original data: We reversed the polarity of the item variables by mapping the "worst" category to the lowest number). We also combined the two highest trust categories to trust category 4.
}
\keyword{datasets}
