#' A snapshot of the NSDUH 2019 data 
#'
#'  These data are from Nahhas (2024) to illustrate quasi-complete separation in his book Introduction to Regression Methods for Public Health Using R.
#'
#' @format A 843 x 4 data frame:  
#' \describe{
#'   \item{her_lifetime}{A binary factor of heroin consumption in a person's lifetime ('No' and 'Yes').}
#'   \item{alc_agefirst}{Age at first use of alcohol.}
#'   \item{demog_age_cat6}{Current age category of the person.} 
#'   \item{demog_sex}{Sex of the person "Male" or ""Female".} 
#' }
#'
#' @source Nahhas R. (2024). Introduction to Regression Methods for Public Health Using R. Chapman & Hall. 
#' @name nsduh2019
#' @docType data
#' @keywords datasets
#' @usage data(nsduh2019)
NULL
