% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{remove_noise_sor}
\alias{remove_noise_sor}
\title{Remove sparse outlier points using Statistical Outlier Removal (SOR)}
\usage{
remove_noise_sor(las, height_thresh = 5, k = 20, zscore = 2.5)
}
\arguments{
\item{las}{A LAS object.}

\item{height_thresh}{Numeric. Height (meters) above which filtering is applied.}

\item{k}{Integer. Number of nearest neighbors.}

\item{zscore}{Numeric. Standard deviation multiplier.}
}
\value{
A filtered LAS object.
}
\description{
Applies a k-nearest-neighbor–based Statistical Outlier Removal (SOR)
filter to points above a user-defined height threshold. Points below
the threshold are preserved.
}
\examples{
\dontrun{
library(lidR)
las <- readLAS("trees.laz")
las_clean <- remove_noise_sor(las, height_thresh = 5, k = 20, zscore = 2.5)
}

}
