% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{evaluate_two_las}
\alias{evaluate_two_las}
\title{Evaluate two LAS files (truth vs prediction)}
\usage{
evaluate_two_las(
  truth_las,
  pred_las,
  truth_col = "label",
  pred_col = "Classification"
)
}
\arguments{
\item{truth_las}{LAS containing ground-truth labels}

\item{pred_las}{LAS containing predicted labels}

\item{truth_col}{Name of truth label field in truth_las (default = "label")}

\item{pred_col}{Name of prediction field in pred_las (default = "Classification")}
}
\value{
list with confusion matrix, accuracy, precision, recall, F1
}
\description{
Computes confusion matrix, accuracy, and per-class precision/recall/F1
using two separate LAS/LAZ files that are point-wise aligned.
}
