% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py_deps.R
\name{ensure_py_env}
\alias{ensure_py_env}
\title{Ensure a Conda environment and Python deps for FuelDeep3D}
\usage{
ensure_py_env(
  envname = "pointnext",
  python_version = "3.10",
  reinstall = FALSE
)
}
\arguments{
\item{envname}{Name of the Conda environment to use/create.
Defaults to \code{"pointnext"}.}

\item{python_version}{Python version to use when creating the env
(ignored if env already exists). Default: \code{"3.10"}.}

\item{reinstall}{Logical; if \code{TRUE}, always reinstall Python deps
even if key modules are already present. Default: \code{FALSE}.}
}
\value{
Invisibly returns \code{TRUE} if the environment exists/was created
and is ready to use.
}
\description{
This helper will:
\enumerate{
\item Check if the Conda env exists; if not, create it with the requested
Python version.
\item Check whether key Python modules are importable from that env.
If any are missing, it installs the full dependency set via pip.
\item Activate the env for the current R session via \code{reticulate::use_condaenv()}.
}
}
