\encoding{UTF-8}
\name{examples}
\alias{examples}
\alias{demos}
\title{Run package examples and demos}
\description{
  Run examples and demos in the package, showing output on screen or saved to PNG files.
}

\details{

\code{examples} and \code{demos} are meta-demos that run all the examples (from the help pages) and other demos in the package.
Run these demos with \code{ask = FALSE} to proceed without asking the user.

\code{examples_png} and \code{demos_png} run all the examples and demos, saving output to PNG files.
The plots are saved in \code{\link{png}} files whose names begin with the names of the help topics or demos.

The package demos are described below.

  \describe{
    \item{references}{Cross-check the references in refs.csv with the thermodynamic database}
    \item{affinity}{Affinities of metabolic reactions and amino acid synthesis (Amend and Shock, 1998, 2001)}
    \item{dehydration}{\logK of dehydration reactions}
    \item{NaCl}{Equilibrium constant for aqueous NaCl dissociation (Shock et al., 1992)}
    \item{density}{Density of \H2O, inverted from IAPWS-95 equations (\code{\link{rho.IAPWS95}})}
    \item{ORP}{Temperature dependence of oxidation-reduction potential for redox standards}
    \item{ionize}{ionize.aa(): contour plots of net charge and ionization properties of LYSC_CHICK}
    \item{buffer}{Minerals and aqueous species as buffers of hydrogen fugacity (Schulte and Shock, 1995)}
    \item{protbuff}{Chemical activities buffered by thiol peroxidases or sigma factors}
    \item{glycinate}{Metal-glycinate complexes (Shock and Koretsky, 1995; Azadi et al., 2019)}
    \item{mosaic}{Eh-pH diagram with two sets of changing basis species (Garrels and Christ, 1965)}
    \item{copper}{Another example of \code{\link{mosaic}}: complexation of Cu with glycine (Aksu and Doyle, 2001)}
    \item{arsenic}{Another example of \code{\link{mosaic}}: Eh-pH diagram for the system As-O-H-S (Lu and Zhu, 2011)}
    \item{solubility}{Solubility of calcite (cf. Manning et al., 2013) and \CO2 (cf. Stumm and Morgan, 1996)}
    \item{gold}{Solubility of gold (Akinfiev and Zotov; 2001; Stef{\aacute}nsson and Seward, 2004; Williams-Jones et al., 2009)}
    \item{contour}{Gold solubility contours on a log fO2 - pH diagram (Ding et al., 2023)}
    \item{sphalerite}{Solubility of sphalerite (Akinfiev and Tagirov, 2014)}
    \item{minsol}{Solubilities of multiple minerals}
    \item{Shh}{Affinities of transcription factors relative to Sonic hedgehog (Dick, 2015)}
    \item{saturation}{Equilibrium activity diagram showing activity ratios and mineral saturation limits (Bowers et al., 1984)}
    \item{adenine}{HKF regression of heat capacity and volume of aqueous adenine (Lowe et al., 2017)}
    \item{DEW}{Deep Earth Water (DEW) model for high pressures (Sverjensky et al., 2014a and 2014b)}
    \item{lambda}{Effects of lambda transition on thermodynamic properties of quartz (Berman, 1988)}
    \item{potassium}{Comparison of thermodynamic datasets for predicting mineral stabilities (Sverjensky et al., 1991)}
    \item{TCA}{Standard Gibbs energies of the tricarboxylic (citric) acid cycle (Canovas and Shock, 2016)}
    \item{aluminum}{Reactions involving Al-bearing minerals (Zimmer et al., 2016; Tutolo et al., 2014)}
    \item{carboxylase}{Rank abundance distribution for RuBisCO and acetyl-CoA carboxylase}
    \item{AD}{Dissolved gases: Henry's constant, volume, and heat capacity (Akinfiev and Diamond, 2003)}
    \item{comproportionation}{Gibbs energy of sulfur comproportionation (Amend et al., 2020)}
    \item{Pourbaix}{Eh-pH diagram for Fe-O-H with equisolubility lines (Pourbaix, 1974)}
    \item{E_coli}{Gibbs energy of biomass synthesis in \emph{E. coli} (LaRowe and Amend, 2016)}
    \item{rank.affinity}{Affinity ranking for proteins in yeast nutrient limitation (data from Tai et al., 2005)}
    \item{yttrium}{\code{\link{logK.to.OBIGT}} fits at 800 and 1000 bar and Y speciation in \code{\link{NaCl}} solution at varying pH (Guan et al., 2020)}
    \item{uranyl}{Total (carbonate|sulfate)-pH diagrams for uranyl species (Migdisov et al., 2025)}
    \item{sum_S}{Summed molality of S species and solubility contours for iron and gold (Skirrow and Walshe, 2002)}
    \item{MgATP}{Speciation of ATP with H+ and Mg+2 (Alberty, 2003)}
    \item{rubisco_Zc}{Zc of Rubisco vs optimal growth temperature}
    \item{phosphorylate}{Phosphorylation model for Gibbs energy of nucleotide polymerization into RNA (LaRowe and Dick, 2025)}
  }


Two of the demos have external dependencies and are not automatically run by \code{demos}.
\samp{carboxylase} creates an animated GIF; this demo requires that the ImageMagick \code{convert} commmand be available on the system (tested on Linux and Windows).

\samp{carboxylase} animates diagrams showing rankings of calculated chemical activities along a combined \T and \logaH2 gradient, or makes a single plot on the default device (without conversion to animated GIF) if a single temperature (\code{T}) is specified in the code.
To run this demo, an empty directory named \samp{png} must be present (as a subdirectory of the R working directory).
The proteins in the calculation are 24 carboxylases from a variety of organisms.
There are 12 ribulose phosphate carboxylase and 12 acetyl-coenzyme A carboxylase; 6 of each type are from nominally mesophilic organisms and 6 from nominally thermophilic organisms, shown as blue and red symbols on the diagrams.
The activities of hydrogen at each temperature are calculated using \eqn{\log a_{\mathrm{H_{2}}_{\left(aq\right)}}=-11+3/\left(40\times T\left(^{\circ}C\right)\right)}{logaH2 = -11 + 3/40 * T(degC)}; this equation comes from a model of relative stabilities of proteins in a hot-spring environment (Dick and Shock, 2011).

}

\section{Warning}{
The discontinuities apparent in the plot made by the \code{NaCl} demo illustrate limitations of the "\emph{g} function" for charged species in the revised HKF model (the 355 \degC boundary of region II in Figure 6 of Shock et al., 1992).
Note that \acronym{SUPCRT92} (Johnson et al., 1992) gives similar output at 500 bar.
However, \acronym{SUPCRT} does not output thermodynamic properties above 350 \degC at \Psat; see Warning in \code{\link{subcrt}}.
}

\references{
Akinfiev NN, Diamond LW. 2003. Thermodynamic description of aqueous nonelectrolytes at infinite dilution over a wide range of state parameters. \emph{Geochim Cosmochim Acta} \bold{67}: 613--629. \doi{10.1016/S0016-7037(02)01141-9}

Akinfiev NN, Tagirov BR. 2014. Zn in hydrothermal systems: Thermodynamic description of hydroxide, chloride, and hydrosulfide complexes. \emph{Geochem Int} \bold{52}: 197--214. \doi{10.1134/S0016702914030021}

Akinfiev NN, Zotov AV. 2001. Thermodynamic description of chloride, hydrosulfide, and hydroxo complexes of Ag(I), Cu(I), and Au(I) at temperatures of 25--500°C and pressures of 1--2000 bar. \emph{Geochem Int} \bold{39}: 990--1006.

Aksu S, Doyle FM. 2001. Electrochemistry of copper in aqueous glycine solutions. \emph{J Electrochem Soc} \bold{148}: B51--B57. \doi{10.1149/1.1344532}

Alberty RA. 2003. \emph{Thermodynamics of Biochemical Reactions}. Hoboken, NJ: John Wiley & Sons. 397 p. \url{https://www.worldcat.org/oclc/51242181}

Amend JP, Shock EL. 1998. Energetics of amino acid synthesis in hydrothermal ecosystems. \emph{Science} \bold{281}: 1659--1662. \doi{10.1126/science.281.5383.1659}

Amend JP, Shock EL. 2001. Energetics of overall metabolic reactions of thermophilic and hyperthermophilic Archaea and Bacteria. \emph{FEMS Microbiol Rev} \bold{25}: 175--243. \doi{10.1016/S0168-6445(00)00062-0}

Amend JP, Aronson HS, Macalady J, LaRowe DE. 2020. Another chemolithotrophic metabolism missing in nature: sulfur comproportionation. \emph{Environ Microbiol} \bold{22}: 1971--1976. \doi{10.1111/1462-2920.14982}

Azadi MR, Karrech A, Attar M, Elchalakani M. 2019. Data analysis and estimation of thermodynamic properties of aqueous monovalent metal-glycinate complexes. \emph{Fluid Phase Equilib} \bold{480}: 25--40. \doi{10.1016/j.fluid.2018.10.002}

Berman RG. 1988. Internally-consistent thermodynamic data for minerals in the system Na{\s2}O-K{\s2}O-CaO-MgO-FeO-Fe{\s2}O{\s3}-Al{\s2}O{\s3}-SiO{\s2}-TiO{\s2}-H{\s2}O-CO{\s2}. \emph{J Petrol} \bold{29}: 445--522. \doi{10.1093/petrology/29.2.445}

Bowers TS, Jackson KJ, Helgeson HC. 1984. \emph{Equilibrium Activity Diagrams for Coexisting Minerals and Aqueous Solutions at Pressures and Temperatures to 5 kb and 600°C}. Berlin: Springer-Verlag. 397 p. \url{https://www.worldcat.org/oclc/11133620}

Canovas PA III, Shock EL. 2016. Geobiochemistry of metabolism: Standard state thermodynamic properties of the citric acid cycle. \emph{Geochim Cosmochim Acta} \bold{195}: 293--322. \doi{10.1016/j.gca.2016.08.028}

Dick JM, Shock EL. 2011. Calculation of the relative chemical stabilities of proteins as a function of temperature and redox chemistry in a hot spring. \emph{PLOS One} \bold{6}: e22782. \doi{10.1371/journal.pone.0022782}

Dick JM. 2015. Chemical integration of proteins in signaling and development. \emph{bioRxiv}. \doi{10.1101/015826}

Ding Z, Sun X, Hu S, Chen H, Li D, Fu Y, Xu L, Wu Z, Huang F. 2023. Role of carbonaceous material in gold precipitation for orogenic gold deposits: A case study of the Bangbu gold deposit in southern Tibet, China. \emph{Ore Geol Rev} \bold{152}: 105231. \doi{10.1016/j.oregeorev.2022.105231}

Garrels RM, Christ CL. 1965. \emph{Solutions, Minerals, and Equilibria}. New York: Harper & Row. 450 p. \url{https://www.worldcat.org/oclc/517586}

Guan Q, Mei Y, Etschmann B, Testemale D, Louvel M, Brugger J. 2020. Yttrium complexation and hydration in chloride-rich hydrothermal fluids: A combined \emph{ab initio} molecular dynamics and \emph{in situ} X-ray absorption spectroscopy study. \emph{Geochim Cosmochim Acta} \bold{281}: 168--189. \doi{10.1016/j.gca.2020.04.015}

Johnson JW, Oelkers EH, Helgeson HC. 1992. SUPCRT92: A software package for calculating the standard molal thermodynamic properties of minerals, gases, aqueous species, and reactions from 1 to 5000 bar and 0 to 1000°C. \emph{Comput Geosci} \bold{18}: 899--947. \doi{10.1016/0098-3004(92)90029-Q}

LaRowe DE, Amend JP. 2016. The energetics of anabolism in natural settings. \emph{ISME J} \bold{10}: 1285--1295. \doi{10.1038/ismej.2015.227}

LaRowe DE, Dick JM. 2025. Physicochemical constraints on the abiotic polymerization of nucleotides into RNA. \emph{JGR Biogeosci} \bold{130}: e2025JG009095. \doi{10.1029/2025JG009095}

Lowe AR, Cox JS, Tremaine PR. 2017. Thermodynamics of aqueous adenine: Standard partial molar volumes and heat capacities of adenine, adeninium chloride, and sodium adeninate from \emph{T} = 278.15 K to 393.15 K. \emph{J Chem Thermodyn} \bold{112}: 129--145. \doi{10.1016/j.jct.2017.04.005}

Lu P, Zhu C. 2011. Arsenic Eh--pH diagrams at 25°C and 1 bar. \emph{Environ Earth Sci} \bold{62}: 1673--1683. \doi{10.1007/s12665-010-0652-x}
  
Manning CE, Shock EL, Sverjensky DA. 2013. The chemistry of carbon in aqueous fluids at crustal and upper-mantle conditions: Experimental and theoretical constraints. \emph{Rev Mineral Geochem} \bold{75}: 109--148. \doi{10.2138/rmg.2013.75.5}

Migdisov A, Bastrakov E, Alcorn C, Reece M, Boukhalfa H, Caporuscio FA, Jove-Colon C. 2025. A spectroscopic study of the stability of uranyl-carbonate complexes at 25--150°C and re-visiting the data available for uranyl-chloride, uranyl-sulfate, and uranyl-hydroxide species. \emph{Geochim Cosmochim Acta} \bold{406}: 326--339. \doi{10.1016/j.gca.2024.04.023}

Pourbaix M. 1974. \emph{Atlas of Electrochemical Equilibria in Aqueous Solutions}. Houston, TX: NACE; Brussels: CEBELCOR. \url{https://www.worldcat.org/oclc/563921897}

Schulte MD, Shock EL. 1995. Thermodynamics of Strecker synthesis in hydrothermal systems. \emph{Orig Life Evol Biosph} \bold{25}: 161--173. \doi{10.1007/BF01581580}

Shock EL, Koretsky CM. 1995. Metal-organic complexes in geochemical processes: Estimation of standard partial molal thermodynamic properties of aqueous complexes between metal cations and monovalent organic acid ligands at high pressures and temperatures. \emph{Geochim Cosmochim Acta} \bold{59}: 1497--1532. \doi{10.1016/0016-7037(95)00058-8}

Shock EL, Oelkers EH, Johnson JW, Sverjensky DA, Helgeson HC. 1992. Calculation of the thermodynamic properties of aqueous species at high pressures and temperatures: Effective electrostatic radii, dissociation constants and standard partial molal properties to 1000 °C and 5 kbar. \emph{J Chem Soc Faraday Trans} \bold{88}: 803--826. \doi{10.1039/FT9928800803}

Skirrow RG, Walshe JL. 2002. Reduced and oxidized Au-Cu-Bi iron oxide deposits of the Tennant Creek Inlier, Australia: An integrated geologic and chemical model. \emph{Econ Geol} \bold{97}: 1167--1202. \doi{10.2113/gsecongeo.97.6.1167}

Stefánsson A, Seward TM. 2004. Gold(I) complexing in aqueous sulphide solutions to 500°C at 500 bar. \emph{Geochim Cosmochim Acta} \bold{68}: 4121--4143. \doi{10.1016/j.gca.2004.04.006}

Stumm W, Morgan JJ. 1996. \emph{Aquatic Chemistry: Chemical Equilibria and Rates in Natural Waters}. 3rd ed. New York: John Wiley & Sons. 1040 p. \url{https://www.worldcat.org/oclc/31754493}

Sverjensky DA, Hemley JJ, D'Angelo WM. 1991. Thermodynamic assessment of hydrothermal alkali feldspar-mica-aluminosilicate equilibria. \emph{Geochim Cosmochim Acta} \bold{55}: 989--1004. \doi{10.1016/0016-7037(91)90157-Z}

Sverjensky DA, Harrison B, Azzolini D. 2014a. Water in the deep Earth: The dielectric constant and the solubilities of quartz and corundum to 60 kb and 1,200°C. \emph{Geochim Cosmochim Acta} \bold{129}: 125--145. \doi{10.1016/j.gca.2013.12.019}

Sverjensky DA, Stagno V, Huang F. 2014b. Important role for organic carbon in subduction-zone fluids in the deep carbon cycle. \emph{Nat Geosci} \bold{7}: 909--913. \doi{10.1038/ngeo2291}

Tai SL, Boer VM, Daran-Lapujade P, Walsh MC, de Winde JH, Daran J-M, Pronk JT. 2005. Two-dimensional transcriptome analysis in chemostat cultures: Combinatorial effects of oxygen availability and macronutrient limitation in \emph{Saccharomyces cerevisiae}. \emph{J Biol Chem} \bold{280}: 437--447. \doi{10.1074/jbc.M410573200}

Tutolo BM, Kong X-Z, Seyfried WE Jr, Saar MO. 2014. Internal consistency in aqueous geochemical data revisited: Applications to the aluminum system. \emph{Geochim Cosmochim Acta} \bold{133}: 216--234. \doi{10.1016/j.gca.2014.02.036}

Williams-Jones AE, Bowell RJ, Migdisov AA. 2009. Gold in solution. \emph{Elements} \bold{5}: 281--287. \doi{10.2113/gselements.5.5.281}

Zimmer K, Zhang Y, Lu P, Chen Y, Zhang G, Dalkilic M, Zhu C. 2016. SUPCRTBL: A revised and extended thermodynamic dataset and software package of SUPCRT92. \emph{Comput Geosci} \bold{90}: 97--111. \doi{10.1016/j.cageo.2016.02.013}
}


\examples{
# Run all the examples (about 20 s)
\dontrun{demo(examples, ask = FALSE)}

# Run all the demos (about 4 min)
\dontrun{demo(demos, ask = FALSE)}
}

\concept{Other tools}
